<?php namespace ProcessWire;

# ---------------------------------------------------------------------
# ImmoImport
# ---------------------------------------------------------------------

### Beispiel Template Code, Objektlisten Logik und Ausgabe

#######################################################################

echo '<!DOCTYPE html>' . PHP_EOL;
echo '<html lang="de">' . PHP_EOL;
echo '    <head>' . PHP_EOL;
echo '        <meta charset="utf-8">' . PHP_EOL;
echo '        <title>ImmoImport Objektliste</title>' . PHP_EOL;
echo '        <style>' . PHP_EOL;
echo '            body {' . PHP_EOL;
echo '                padding: 2em; ' . PHP_EOL;
echo '                color: #343a40; ' . PHP_EOL;
echo '                background-color: #ffffff;' . PHP_EOL;
echo '                font-family: monospace;' . PHP_EOL;
echo '            }' . PHP_EOL;
echo '            hr {' . PHP_EOL;
echo '                margin: 1.6em 0; ' . PHP_EOL;
echo '            }' . PHP_EOL;
echo '        </style>' . PHP_EOL;
echo '    </head>' . PHP_EOL;
echo '    <body>' . PHP_EOL;

echo '<h1>ImmoImport Beispiel Objektliste</h1>' . PHP_EOL;
echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Hilfsfunktionen inkludieren

require_once('immoimport_functions.inc.php');

# ---------------------------------------------------------------------

# ImmoImport Einstellung abfragen

echo '<h2>Funktion immoGetModuleSetting()</h2>' . PHP_EOL;
echo '<h3>ImmoImport Einstellung abfragen</h3>' . PHP_EOL;
echo '<p>ImmoImport Einstellung Exposé Template Name: ' . immoGetModuleSetting('exposeTemplateName') . '</p>' . PHP_EOL;
echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Objekte zählen

echo '<h2>Funktion immoCountProperties()</h2>' . PHP_EOL;
echo '<h3>Objekte zählen</h3>' . PHP_EOL;
echo '<p>Aktuell sind ' . immoCountProperties() . ' Objekt(e) verfügbar</p>' . PHP_EOL;
echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Objekte finden mit Filter (Selektor)
# Treffer auflisten

echo '<h2>Funktion immoFindProperties()</h2>' . PHP_EOL;
echo '<h3>Objekte finden mit Filter (Selektor)</h3>' . PHP_EOL;

$filter = 'start=0, limit=1000, sort=random, ';
$filter .= 'i_obj_objektart=wohnung|haus, ';
$filter .= 'i_obj_vermarktungsart_kauf=1, ';
$filter .= 'i_fla_wohnflaeche>=10';

# Beispiel für die sichere Behandlung externer Werte (Get, Post)

# $filterValueFromUser = $sanitizer->selectorValue($input->get->filterValueFromUser);
# $filter .= 'feldname=' . $filterValueFromUser;

$properties = immoFindProperties($filter);

echo '<p>Aktuell sind ' . $properties->count . ' Objekt(e) zum Kauf ab 10 m² Wohnfläche verfügbar</p>' . PHP_EOL;

foreach ($properties as $property) {
    echo '<p><a href="' . $property->url . '">' . $property->title . ' (' . immoFormatSpace($property->i_fla_wohnflaeche) . ')</a></p>' . PHP_EOL;
}

echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Objekte finden ohne Filter (Selektor)
# Treffer auflisten als Kurzexposé

echo '<h2>Funktion immoRenderExposeShort()</h2>' . PHP_EOL;
echo '<h3>Objekte als Kurzexposé ausgeben</h3>' . PHP_EOL;

foreach (immoFindProperties() as $property) {
    echo immoRenderExposeShort($property);
}

echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

echo '    </body>' . PHP_EOL;
echo '</html>' . PHP_EOL;

# ---------------------------------------------------------------------

?>
