<?php namespace ProcessWire;

# ---------------------------------------------------------------------
# ImmoImport
# ---------------------------------------------------------------------

### Beispiel Template Code, Import durchführen

#######################################################################

echo '<!DOCTYPE html>' . PHP_EOL;
echo '<html lang="de">' . PHP_EOL;
echo '    <head>' . PHP_EOL;
echo '        <meta charset="utf-8">' . PHP_EOL;
echo '        <title>ImmoImport Import</title>' . PHP_EOL;
echo '        <style>' . PHP_EOL;
echo '            body {' . PHP_EOL;
echo '                padding: 2em; ' . PHP_EOL;
echo '                color: #ffffff; ' . PHP_EOL;
echo '                background-color: #08325D;' . PHP_EOL;
echo '                font-family: monospace;' . PHP_EOL;
echo '            }' . PHP_EOL;
echo '            hr {' . PHP_EOL;
echo '                margin: 1.6em 0; ' . PHP_EOL;
echo '            }' . PHP_EOL;
echo '        </style>' . PHP_EOL;
echo '    </head>' . PHP_EOL;
echo '    <body>' . PHP_EOL;

# ---------------------------------------------------------------------

if ($modules->isInstalled('ImmoImport') && $import = $modules->ImmoImport->prepare()) {

    # Modul ist installiert und der Importprozess wurde erfolgreich vorbereitet…

    # Import anstoßen (Updates finden und verarbeiten nach aktueller Konfiguration)
    $import->processUpdates();

    # [Löschhilfe] Alle Objekte im System in den Papierkorb verschieben (Bestand nullen)
    # Der nächste Import sollte dann wieder ein Vollabgleich sein (alle Objekte enthalten)
    # $import->removeProperties();

    # [Löschhilfe] Alle Objekte im System endgültig löschen (Bestand löschen inkl. Papierkorb)
    # Der nächste Import sollte dann wieder ein Vollabgleich sein (alle Objekte enthalten)
    # Ein großer Umfang erfordert evtl. die mehrfache Ausführung dieser Hilfsfunktion
    # $import->deleteProperties();

    # [Löschhilfe] Alle vom Modul mit der aktuellen Konfiguration verknüpften Seiten, Felder,
    # Templates und Logs endgültig löschen, sofern möglich (alles löschen inkl. Papierkorb)
    # Funktion nur mit Bedacht aktivieren, im Zweifel wird ein vorheriges Backup empfohlen
    # Ein großer Umfang erfordert evtl. die mehrfache Ausführung dieser Hilfsfunktion
    # $import->deleteEverything();

    # Import Log kopieren
    $importFullLog = $import->getFullLog();

    # Import sauber beenden
    $modules->ImmoImport->finish($import);

}

# ---------------------------------------------------------------------

# Import Log ausgeben

if (!empty($importFullLog)) {

    echo '<p><strong>ImmoImport Import Log</strong></p>' . PHP_EOL;

    foreach ($importFullLog as $line) {
        echo '<p>' . htmlspecialchars($line, ENT_COMPAT, 'UTF-8', false) . '</p>' . PHP_EOL;
    }

}

# ---------------------------------------------------------------------

echo '    </body>' . PHP_EOL;
echo '</html>' . PHP_EOL;

# ---------------------------------------------------------------------

?>
