<?php namespace ProcessWire;

# ---------------------------------------------------------------------
# ImmoImport
# ---------------------------------------------------------------------

### Beispiel Template Code, Exposé Logik und Ausgabe

#######################################################################

echo '<!DOCTYPE html>' . PHP_EOL;
echo '<html lang="de">' . PHP_EOL;
echo '    <head>' . PHP_EOL;
echo '        <meta charset="utf-8">' . PHP_EOL;
echo '        <title>ImmoImport Exposé</title>' . PHP_EOL;
echo '        <style>' . PHP_EOL;
echo '            body {' . PHP_EOL;
echo '                padding: 2em; ' . PHP_EOL;
echo '                color: #343a40; ' . PHP_EOL;
echo '                background-color: #ffffff;' . PHP_EOL;
echo '                font-family: monospace;' . PHP_EOL;
echo '            }' . PHP_EOL;
echo '            hr {' . PHP_EOL;
echo '                margin: 1.6em 0; ' . PHP_EOL;
echo '            }' . PHP_EOL;
echo '        </style>' . PHP_EOL;
echo '    </head>' . PHP_EOL;
echo '    <body>' . PHP_EOL;

echo '<h1>ImmoImport Beispiel Exposé</h1>' . PHP_EOL;
echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Hilfsfunktionen inkludieren

require_once('immoimport_functions.inc.php');

# ---------------------------------------------------------------------

# Alle Objektattribute aus dem Feld „Tabellenliste“ bereitstellen
# 1. in Array $tableList['attribut_name' => Wert]
# 2. als Variable einzeln mit Präfix $i_attribut_name = Wert

$tableListText = $page->get('i_intern_table_list');
$tableList = immoGetTableList($tableListText);

foreach ($tableList as $name => $value) {
    $name = 'i_' . $name;
    $$name = !isset($$name) ? $value : $$name;
}

echo '<h2>immoGetTableList()</h2>' . PHP_EOL;
echo '<h3>Objektattribute bereitstellen</h3>' . PHP_EOL;
echo '<p>1. Array (Beispiel: $tableList[\'vet_objektnr_extern\']): ' . $tableList['vet_objektnr_extern'] . '</p>' . PHP_EOL;
echo '<p>2. Variable (Beispiel: $i_vet_objektnr_extern): ' . $i_vet_objektnr_extern . '</p>' . PHP_EOL;
echo '<details>' . PHP_EOL;
echo '    <summary style="font-size: larger; margin-top: 1em; padding: 0.5em; background-color: #f8f8f8; border: 0.1rem solid #343a40;"><strong>Alle ' . count($tableList) . ' Objektattribute ein- und ausblenden (Name|Wert|Typ)</strong></summary>' . PHP_EOL;
echo '    <div style="margin-top: 1.6em;">' . PHP_EOL;
foreach ($tableList as $name => $value) {
    echo '        <div style="background-color: #f8f8f8; border-top: 0.1rem solid #343a40;">';
    echo '<div style="display: inline-block; vertical-align: top; box-sizing: border-box; width: 30%; padding: 0.5em;">' . $name . '</div>';
    echo '<div style="display: inline-block; vertical-align: top; vertical-align: top; box-sizing: border-box; width: 50%; padding: 0.5em;">' . htmlspecialchars($value, ENT_COMPAT, 'UTF-8', false) . '</div>';
    echo '<div style="display: inline-block; vertical-align: top; box-sizing: border-box; width: 20%; padding: 0.5em;">' . gettype($value) . '</div>';
    echo '</div>' . PHP_EOL;
}
    echo '    </div>' . PHP_EOL;
echo '</details>' . PHP_EOL;
echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Preisangabe formatieren und ausgeben

$preis = 123456.5;

echo '<h2>immoFormatPrice()</h2>' . PHP_EOL;
echo '<h3>Preisangabe formatieren und ausgeben</h3>' . PHP_EOL;
echo '<p>' . immoFormatPrice($preis) . '</p>' . PHP_EOL;
echo '<p>' . immoFormatPrice($preis, 0) . '</p>' . PHP_EOL;
echo '<p>' . immoFormatPrice($preis, 2, 'Euro') . '</p>' . PHP_EOL;
echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Platzangabe formatieren und ausgeben

$platz = 1234.56;

echo '<h2>immoFormatSpace()</h2>' . PHP_EOL;
echo '<h3>Platzangabe formatieren und ausgeben</h3>' . PHP_EOL;
echo '<p>' . immoFormatSpace($platz) . '</p>' . PHP_EOL;
echo '<p>' . immoFormatSpace($platz, 4) . '</p>' . PHP_EOL;
echo '<p>' . immoFormatSpace($platz, 1, 'm³ (Kubikmeter)') . '</p>' . PHP_EOL;
echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Zahl formatieren und ausgeben

$zahl = 1234;

echo '<h2>immoFormatNumber()</h2>' . PHP_EOL;
echo '<h3>Zahl formatieren und ausgeben</h3>' . PHP_EOL;
echo '<p>' . immoFormatNumber($zahl) . '</p>' . PHP_EOL;
echo '<p>' . immoFormatNumber($zahl, 1) . '</p>' . PHP_EOL;
echo '<p>' . immoFormatNumber($zahl, 0, 'Stück') . '</p>' . PHP_EOL;
echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Titelbild oder alternativ erstes Bild finden und ausgeben mit Bildtitel

echo '<h2>immoFindTitleImagePage()</h2>' . PHP_EOL;
echo '<h3>Titelbild oder alternativ erstes Bild finden und ausgeben</h3>' . PHP_EOL;

$titleImagePage = immoFindTitleImagePage($page);

if ($titleImagePage->id) {

    $image = $titleImagePage->i_anh_bild;
    $imageTitle = $titleImagePage->i_anh_titel ? $titleImagePage->i_anh_titel : '–';

    echo '<p><img alt="Titelbild" src="' . $image->size(1000, 375)->url . '"></p>' . PHP_EOL;
    echo '<p>Titel: ' . $imageTitle . '</p>' . PHP_EOL;

}

echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Alle Bilder finden und ausgeben mit Bildtitel

echo '<h2>immoFindImagePages()</h2>' . PHP_EOL;
echo '<h3>Alle Bilder finden und ausgeben</h3>' . PHP_EOL;

$imagePages = immoFindImagePages($page);

if ($imagePages) {

    echo '<p><strong>' . $imagePages->count . ' gefunden</strong></p>' . PHP_EOL;

    foreach ($imagePages as $imagePage) {

        $image = $imagePage->i_anh_bild;
        $imageTitle = $imagePage->i_anh_titel ? $imagePage->i_anh_titel : '–';

        echo '<p><img alt="Bild" src="' . $image->size(1000, 375)->url . '"></p>' . PHP_EOL;
        echo '<p>Titel: ' . $imageTitle . '</p>' . PHP_EOL;

    }

}

echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Alle Anhänge finden und Treffer auflisten

echo '<h2>immoFindAttachmentPages()</h2>' . PHP_EOL;
echo '<h3>Alle Anhänge finden und ausgeben</h3>' . PHP_EOL;

$attachmentPages = immoFindAttachmentPages($page);

if ($attachmentPages) {

    echo '<p><strong>' . $attachmentPages->count . ' gefunden</strong></p>' . PHP_EOL;

    foreach ($attachmentPages as $attachmentPage) {

        $title = $attachmentPage->title;
        $format = $attachmentPage->i_anh_format;
        $modified = $attachmentPage->modified;

        echo '<p>Titel: ' . $title . '</p>' . PHP_EOL;
        echo '<p>Format: ' . $format . '</p>' . PHP_EOL;
        echo '<p>Modifiziert: ' . date('d.m.Y H:i', $modified) . '</p>' . PHP_EOL;

    }

}

echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Objektattribute einzeln verarbeiten
# Objektattribute in definierten Listen verarbeiten

echo '<h2>Mit Objektattributen arbeiten</h2>' . PHP_EOL;
echo '<h3>Attribute einzeln oder mit System verarbeiten und ausgeben</h3>' . PHP_EOL;

# Beispiel einzeln

echo '<h4>Beispiel: auf das Attribut \'vet_objektnr_extern\' zugreifen</h4>' . PHP_EOL;
echo '<p>1. Array: ' . $tableList['vet_objektnr_extern'] . '</p>' . PHP_EOL;
echo '<p>2. Variable: ' . $i_vet_objektnr_extern . '</p>' . PHP_EOL;
echo '<p>3. Feldabfrage: ' . $page->get('i_vet_objektnr_extern') . '</p>' . PHP_EOL;

# ---------------------------------------------------------------------

# Attribute Listen (Beispiele Aufbau eigener Listen)

if ($listExample = immoAttrListExample($tableList, $page)) {
    echo '<h4>Beispiel Definition Liste mit beliebigen Objektattributen</h4>' . PHP_EOL;
    echo $listExample;
}

if ($listEnergiepass = immoAttrListEnergiepass($tableList, $page)) {
    echo '<h4>Beispiel Definition Liste Energiepass</h4>' . PHP_EOL;
    echo $listEnergiepass;
}

echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

# Attribute Listen (Basisdaten)

if ($listAnbBasic = immoAttrListAnbBasic($tableList, $page)) {
    echo '<h4>Basisdaten Anbieter</h4>' . PHP_EOL;
    echo $listAnbBasic;
}

if ($listObjBasic = immoAttrListObjBasic($tableList, $page)) {
    echo '<h4>Basisdaten Objektkategorie</h4>' . PHP_EOL;
    echo $listObjBasic;
}

if ($listGeoBasic = immoAttrListGeoBasic($tableList, $page)) {
    echo '<h4>Basisdaten Geo</h4>' . PHP_EOL;
    echo $listGeoBasic;
}

if ($listKonBasic = immoAttrListKonBasic($tableList, $page)) {
    echo '<h4>Basisdaten Kontaktperson</h4>' . PHP_EOL;
    echo $listKonBasic;
}

if ($listWeiBasic = immoAttrListWeiBasic($tableList, $page)) {
    echo '<h4>Basisdaten Weitere Adresse</h4>' . PHP_EOL;
    echo $listWeiBasic;
}

if ($listPreBasic = immoAttrListPreBasic($tableList, $page)) {
    echo '<h4>Basisdaten Preise</h4>' . PHP_EOL;
    echo $listPreBasic;
}

if ($listBieBasic = immoAttrListBieBasic($tableList, $page)) {
    echo '<h4>Basisdaten Bieterverfahren</h4>' . PHP_EOL;
    echo $listBieBasic;
}

if ($listVerBasic = immoAttrListVerBasic($tableList, $page)) {
    echo '<h4>Basisdaten Versteigerung</h4>' . PHP_EOL;
    echo $listVerBasic;
}

if ($listFlaBasic = immoAttrListFlaBasic($tableList, $page)) {
    echo '<h4>Basisdaten Flächen</h4>' . PHP_EOL;
    echo $listFlaBasic;
}

if ($listAusBasic = immoAttrListAusBasic($tableList, $page)) {
    echo '<h4>Basisdaten Ausstattung</h4>' . PHP_EOL;
    echo $listAusBasic;
}

if ($listZusBasic = immoAttrListZusBasic($tableList, $page)) {
    echo '<h4>Basisdaten Zustand Angaben</h4>' . PHP_EOL;
    echo $listZusBasic;
}

if ($listBewBasic = immoAttrListBewBasic($tableList, $page)) {
    echo '<h4>Basisdaten Bewertung</h4>' . PHP_EOL;
    echo $listBewBasic;
}

if ($listInfBasic = immoAttrListInfBasic($tableList, $page)) {
    echo '<h4>Basisdaten Infrastruktur</h4>' . PHP_EOL;
    echo $listInfBasic;
}

if ($listFreBasic = immoAttrListFreBasic($tableList, $page)) {
    echo '<h4>Basisdaten Freitexte</h4>' . PHP_EOL;
    echo $listFreBasic;
}

if ($listVeoBasic = immoAttrListVeoBasic($tableList, $page)) {
    echo '<h4>Basisdaten Verwaltung Objekt</h4>' . PHP_EOL;
    echo $listVeoBasic;
}

if ($listVetBasic = immoAttrListVetBasic($tableList, $page)) {
    echo '<h4>Basisdaten Verwaltung Technik</h4>' . PHP_EOL;
    echo $listVetBasic;
}

# ---------------------------------------------------------------------

echo '<hr>' . PHP_EOL;

# ---------------------------------------------------------------------

echo '    </body>' . PHP_EOL;
echo '</html>' . PHP_EOL;

# ---------------------------------------------------------------------

?>
